jQuery(document).ready(function ($) {
  $("#disconnect_phone_button").on("click", function () {
    if (!confirm("Are you sure you want to disconnect this phone?")) return;

    $.ajax({
      url: whatsappQR.ajax_url,
      type: "POST",
      data: {
        action: "disconnect_whatsapp_phone",
        nonce: whatsappQR.nonce,
      },
      success: function (response) {
        if (response.success) {
          $("#disconnect_status").html(
            "✅ Phone disconnected. Page is refreshing..."
          );
          setTimeout(() => {
            window.location.reload();
          }, 2000);
        } else {
          $("#disconnect_status").html("❌ " + response.data);
        }
      },
      error: function () {
        $("#disconnect_status").html("❌ AJAX error occurred.");
      },
    });
  });

  $("#generate_qr_button").on("click", function (e) {
    e.preventDefault();
    let phone = $("#whatsapp_phone").val();

    if (!phone) {
      alert("Please enter a phone number");
      return;
    }

    $.ajax({
      url: whatsappQR.ajax_url,
      type: "POST",
      data: {
        action: "generate_whatsapp_qr",
        phone: phone,
        nonce: whatsappQR.nonce,
      },
      success: function (res) {
        if (res.data.connected) {
          pollStatus(phone); // Start session status polling
          return;
        }
        pollQR(phone); // Pass phone number
      },
      error: function () {
        $("#qr_result").html(
          '<div style="color:red;">QR generation failed.</div>'
        );
      },
    });
  });

  function pollQR(phone) {
    $.ajax({
      url: whatsappQR.ajax_url,
      type: "POST",
      dataType: "json",
      data: {
        action: "get_qr_from_server",
        phone: phone,
        nonce: whatsappQR.nonce,
      },
      success: function (response) {
        if (response.success && response.data.qr) {
          $("#qr_code").show();
          $("#qr_code").attr("src", response.data.qr);
          pollStatus(phone); // Start session status polling
        } else {
          setTimeout(() => pollQR(phone), 2000);
        }
      },
      error: function () {
        console.error("Error fetching QR code");
        setTimeout(() => pollQR(phone), 2000);
      },
    });
  }

  function pollStatus(phone) {
    $.ajax({
      url: whatsappQR.ajax_url,
      type: "POST",
      dataType: "json",
      data: {
        action: "check_whatsapp_session_status",
        phone: phone,
        nonce: whatsappQR.nonce,
      },
      success: function (response) {
        if (response.success && response.data.connected) {
          alert(
            "✅ WhatsApp session connected successfully! Save the settings."
          );
        } else {
          setTimeout(() => pollStatus(phone), 5000);
        }
      },
      error: function () {
        console.error("Error checking session status");
        setTimeout(() => pollStatus(phone), 5000);
      },
    });
  }
});
