<?php
// Ensure no direct access to this file
if (!defined('ABSPATH')) {
    exit;
}

class WhatsAppNotifier
{

    public function __construct() {}

    public static function fixPhoneNumber($phone)
    {
        // remove landing +
        if (substr($phone, 0, 1) == "+") {
            $phone = substr($phone, 1);
        }
        return $phone;
    }

    public static function generate_unique_coupon_code()
    {
        // $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $characters = '0123456789';
        $length = 6;

        do {
            $coupon_code = '';
            for ($i = 0; $i < $length; $i++) {
                $coupon_code .= $characters[mt_rand(0, strlen($characters) - 1)];
            }
            $exists = WhatsAppNotifier::coupon_exists($coupon_code);
        } while (!empty($exists));

        return $coupon_code;
    }

    public static  function coupon_exists($coupon_code)
    {
        $coupon = new WC_Coupon($coupon_code);
        return ($coupon->get_id() > 0);
    }

    public static  function generateCoupon($amount)
    {
        $coupon_code = WhatsAppNotifier::generate_unique_coupon_code(); // Code
        $discount_type = 'percent'; // Type: fixed_cart, percent, fixed_product, percent_product

        $coupon = new WC_Coupon();
        $coupon->set_code($coupon_code);
        $coupon->set_discount_type($discount_type);
        $coupon->set_amount($amount);
        $coupon->set_date_expires(date('Y-m-d H:i:s', strtotime('+10 hours'))); // Set expiration date with time
        $coupon->set_usage_limit(1); // Limit usage to 1 time
        $coupon->set_usage_limit_per_user(1); // Limit usage to 1 time per user
        $coupon->set_individual_use(true); // True: cannot be used in conjunction with other coupons
        //$coupon->set_product_ids(array(1234, 5678)); // Array of product IDs - the coupon will apply to these products
        // $coupon->set_exclude_product_ids(array(7890)); // Array of product IDs - the coupon will not apply to these products
        //$coupon->set_product_categories(array(9, 14)); // Array of category IDs - the coupon will apply to products in these categories
        // $coupon->set_exclude_product_categories(array(15)); // Array of category IDs - the coupon will not apply to products in these categories
        //$coupon->set_minimum_amount('100'); // Minimum spend (subtotal)
        // $coupon->set_email_restrictions(array('example@example.com')); // Allowed emails

        $coupon->save(); // Save the data
        return $coupon_code;
    }

    public static function sendRequestCustomWhatsappApi($phoneNumber, $message, $customer_phone)
    {
        $sessionId = $customer_phone;
        $messageType = 'text';
        $text = $message;
        $mediaUrl = null; // or a valid URL if it's a media message
        $fromMe = true;
        $timestamp = gmdate('Y-m-d H:i:s');
        $WEBHOOK_URL = "https://gateway.ask-us.link/api?q_type=get_whatsapp_notification";

        // Build the message payload
        $messageData = [
            'sessionId' => $sessionId,
            'conversation' => $phoneNumber . '@c.us',
            'user' => [
                'phone' => $phoneNumber,
                'name' => $phoneNumber
            ],
            'receiver' => $sessionId,
            'message' => [
                'type' => $messageType,
                'text' => $text,
                'mediaUrl' => $mediaUrl,
                'fromMe' => $fromMe
            ],
            'timestamp' => $timestamp,
            'sent_to_user' => true,
        ];

        error_log("📤 Forwarding message to webhook... " . json_encode($messageData));

        // Send it using curl
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $WEBHOOK_URL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($messageData));

        $response = curl_exec($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);

        if ($curl_error) {
            error_log("❌ Failed to send message to webhook: $curl_error");
        } else {
            error_log("✅ Message forwarded to $WEBHOOK_URL");
        }
    }

    public static function webRequestPost($url, $headers = [], $postData = null)
    {
        $ch = curl_init($url);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            curl_close($ch);
            throw new Exception("cURL error: " . $error_msg);
        }

        curl_close($ch);

        return $response;
    }

    public static function appendNewUserAttempt($ip, $phone)
    {
        $filePath =  __DIR__ . '/data/attempts.json';
        // Check if the file exists and is not empty
        if (file_exists($filePath) && filesize($filePath) > 0) {
            // Get current data from file
            $jsonContents = file_get_contents($filePath);
            $data = json_decode($jsonContents, true);
        } else {
            // Initialize empty array if the file does not exist
            $data = [];
        }

        // Check if the IP or Phone already exists
        $found = false;
        foreach ($data as &$entry) {
            if ($entry['ip'] === $ip || $entry['phone'] === $phone) {
                // Increment the smsAttempt count
                $entry['smsAttempt'] += 1;
                $entry['timestamp'] = gmdate('Y-m-d H:i:s'); // Update the timestamp
                $found = true;
                break;
            }
        }

        // If the IP or Phone is not found, append a new entry
        if (!$found) {
            $data[] = ['ip' => $ip, 'phone' => $phone, 'smsAttempt' => 1, 'timestamp' => gmdate('Y-m-d H:i:s')];
        }

        // Encode data to JSON and save to file
        file_put_contents($filePath, json_encode($data, JSON_PRETTY_PRINT));
    }

    public static function check_attempt_count($ip, $phone)
    {
        $filePath = __DIR__ . '/data/attempts.json';

        // Get the current time minus 2 hours
        $twoHoursAgo = gmdate('Y-m-d H:i:s') - (2 * 60 * 60);

        // Check if the file exists and is not empty
        if (file_exists($filePath) && filesize($filePath) > 0) {
            $jsonContents = file_get_contents($filePath);
            $data = json_decode($jsonContents, true);

            foreach ($data as $entry) {
                // Check if the attempt is within the last 2 hours
                if (isset($entry['timestamp']) && $entry['timestamp'] >= $twoHoursAgo) {
                    if ($entry['ip'] != "185.232.130.200") {
                        if ($entry['ip'] === $ip || $entry['phone'] === $phone) {
                            // Check if smsAttempt is greater than 2
                            if ($entry['smsAttempt'] >= 2) {
                                return false; // Attempts exceed 2
                            } else {
                                return true; // Attempts do not exceed 2
                            }
                        }
                    }
                }
            }
        }

        return true; // Default return true if no relevant recent entry is found

    }
}
