<?php
class WhatsAppUsers
{
    private static function table()
    {
        global $wpdb;
        return $wpdb->prefix . 'whatsapp_notification_users';
    }

    public static function get_by_phone($phone)
    {
        global $wpdb;
        return $wpdb->get_row($wpdb->prepare("SELECT * FROM " . self::table() . " WHERE phone = %s", $phone));
    }


    public static function exists($phone)
    {
        return self::get_by_phone($phone) !== null;
    }

    public static function create_or_update($phone, $data = [])
    {
        try {
            global $wpdb;
            $table = self::table();

            if (self::exists($phone)) {
                // Only update the passed fields — do NOT apply defaults
                $wpdb->update($table, $data, ['phone' => $phone]);
            } else {
                // Apply defaults only when inserting
                $defaults = [
                    'phone' => $phone,
                    'country_code' => '',
                    'phone_verified' => 1,
                    'user_verify_phone_time' => gmdate('Y-m-d H:i:s'),
                    'got_cart_coupon' => 0,
                    'got_verification_coupon' => 0,
                    'coupon_added_to_cart' => 0,
                    'created_at' => gmdate('Y-m-d H:i:s'),
                ];

                $data = array_merge($defaults, $data);
                $wpdb->insert($table, $data);
            }

            if ($wpdb->last_error) {
                error_log("DB Error: " . $wpdb->last_error);
            }
        } catch (Exception $e) {
            error_log('Exception in create_or_update: ' . $e->getMessage());
        }
    }

    public static  function log_whatsapp_newsletter($phone, $message, $campaign_name = null, $success = 1, $error = null)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'whatsapp_newsletters_sent';
        $wpdb->insert($table, [
            'phone'         => sanitize_text_field($phone),
            'message'       => sanitize_textarea_field($message),
            'campaign_name' => sanitize_text_field($campaign_name),
            'success'       => $success ? 1 : 0,
            'error'         => $error ? sanitize_text_field($error) : null,
            'sent_at'       => current_time('mysql', 1),
        ]);
    }


    public static function mark_sent_coupon($phone, $field = 'got_cart_coupon')
    {
        global $wpdb;
        $wpdb->update(self::table(), [$field => 1], ['phone' => $phone]);
    }

    public static function get_all($page = 1, $limit = 20, $filters = [])
    {
        global $wpdb;
        $offset = ($page - 1) * $limit;

        $where = self::build_where($filters);

        $query = "SELECT * FROM " . self::table() . " $where ORDER BY id DESC LIMIT %d OFFSET %d";
        return $wpdb->get_results($wpdb->prepare($query, $limit, $offset));
    }

    public static function get_total($filters = [])
    {
        global $wpdb;

        $where = self::build_where($filters);
        $query = "SELECT COUNT(*) FROM " . self::table() . " $where";

        return $wpdb->get_var($query);
    }

    private static function build_where($filters = [])
    {
        $conditions = [];

        if (!empty($filters['verified']) && in_array($filters['verified'], ['0', '1'])) {
            $conditions[] = "phone_verified = " . intval($filters['verified']);
        }

        if (!empty($filters['coupon_type'])) {
            switch ($filters['coupon_type']) {
                case 'verification':
                    $conditions[] = "got_verification_coupon = 1";
                    break;
                case 'cart':
                    $conditions[] = "got_cart_coupon = 1";
                    break;
                case 'added':
                    $conditions[] = "coupon_added_to_cart = 1";
                    break;
            }
        }

        return count($conditions) ? 'WHERE ' . implode(' AND ', $conditions) : '';
    }


    public static function get_all_not_got_cart_coupon()
    {
        global $wpdb;
        return $wpdb->get_results("SELECT * FROM " . self::table() . " WHERE got_cart_coupon = 0 and got_verification_coupon=0");
    }

    public static function get_all_newsletter_agreed()
    {
        global $wpdb;
        return $wpdb->get_results("SELECT * FROM " . self::table() . " WHERE got_verification_coupon = 1 and phone_verified = 1");
    }
}
