<?php
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');
include_once plugin_dir_path(__FILE__) . 'class-whatsapp-notifier.php';
include_once plugin_dir_path(__FILE__) . 'class_whatsapp_users.php';

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
session_start();

if (isset($_POST['action'])) {
    $action = sanitize_input($_POST['action']);
    if ($action == 'wc_custom_popup_send_sms') {
        if (isset($_POST['phone'])) {
            $fullPhoneNumber = sanitize_input($_POST['phone']);
            $country_code = sanitize_input($_POST['country_code']);
            $fullPhoneNumber = WhatsAppNotifier::fixPhoneNumber($fullPhoneNumber);
            if ($fullPhoneNumber) {
                $ip = '';
                if (isset($_SERVER['HTTP_CLIENT_IP']) && $_SERVER['HTTP_CLIENT_IP']) {
                    $ip = $_SERVER['HTTP_CLIENT_IP'];
                } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && $_SERVER['HTTP_X_FORWARDED_FOR']) {
                    // HTTP_X_FORWARDED_FOR can contain a comma-separated list of IPs, the first one is the real client IP.
                    $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
                    $ip = trim($ipList[0]);
                } elseif (isset($_SERVER['HTTP_X_FORWARDED']) && $_SERVER['HTTP_X_FORWARDED']) {
                    $ip = $_SERVER['HTTP_X_FORWARDED'];
                } elseif (isset($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) && $_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) {
                    $ip = $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
                } elseif (isset($_SERVER['HTTP_FORWARDED_FOR']) && $_SERVER['HTTP_FORWARDED_FOR']) {
                    $ip = $_SERVER['HTTP_FORWARDED_FOR'];
                } elseif (isset($_SERVER['HTTP_FORWARDED']) && $_SERVER['HTTP_FORWARDED']) {
                    $ip = $_SERVER['HTTP_FORWARDED'];
                } elseif (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR']) {
                    $ip = $_SERVER['REMOTE_ADDR'];
                } else {
                    $ip = 'UNKNOWN';
                }
                $canContinue = WhatsAppNotifier::check_attempt_count($ip, $fullPhoneNumber);
                if ($canContinue) {
                    WhatsAppNotifier::appendNewUserAttempt($ip,  $fullPhoneNumber);
                    $user_verify_phone_time = gmdate('Y-m-d H:i:s');
                    WhatsAppUsers::create_or_update($fullPhoneNumber, [
                        'phone' => $fullPhoneNumber,
                        'country_code' => $country_code,
                        'phone_verified' => 0,
                        'user_verify_phone_time' => $user_verify_phone_time,
                        'got_cart_coupon' => 0,
                        'got_verification_coupon' => 1,
                        'coupon_added_to_cart' => 0,
                    ]);

                    $options = get_option('whatsapp_notification_settings');
                    $phone = $options['whatsapp_phone_scan_qr_code'];
                    $whatsapp_notification_initial_coupon_discount = $options['whatsapp_notification_initial_coupon_discount'] ?? '5';  // Using the null coalescing operator to avoid undefined index notice.
                    $new_coupon_code = WhatsAppNotifier::generateCoupon($whatsapp_notification_initial_coupon_discount);
                    $_SESSION["smsCode"] = $new_coupon_code;
                    $message = "Welcome to " .  $_SERVER['HTTP_HOST'] . ". You have received a discount coupon for " . $whatsapp_notification_initial_coupon_discount . "%. You must enter the coupon number at the point of purchase: " . $new_coupon_code . " The coupon is valid for 10 hours. You can enter the site by clicking on the link " . $_SERVER['HTTP_HOST'] . "/?action=fromWhatsapp&sub=verify_phone&country_code=" . $country_code . "&phone=" . $fullPhoneNumber . "&couponCode=" . $new_coupon_code;
                    WhatsAppNotifier::sendRequestCustomWhatsappApi($fullPhoneNumber, $message, $phone);

                    $response = [
                        'status' => 'success',
                        'message' => 'ok'
                    ];
                } else {
                    $response = [
                        'status' => 'error',
                        'message' => 'too many attempts'
                    ];
                }
            } else {
                $response = [
                    'status' => 'error',
                    'message' => ''
                ];
            }
        } else {
            $response = [
                'status' => 'error',
                'message' => 'phone number is missing'
            ];
        }
    } else if ($action == 'wc_custom_popup_verify_phone') {
        if (isset($_POST['phone']) && isset($_POST['code'])) {
            $fullPhoneNumber = sanitize_input($_POST['phone']);
            $fullPhoneNumber = WhatsAppNotifier::fixPhoneNumber($fullPhoneNumber);
            $code = sanitize_input($_POST['code']);
            if (isset($_SESSION["smsCode"]) && $_SESSION["smsCode"] == $code) {
                $user = WhatsAppUsers::get_by_phone($fullPhoneNumber);
                $user_verify_phone_time = gmdate('Y-m-d H:i:s');

                $_SESSION["whatsapp_phone"] =  $fullPhoneNumber;
                $_SESSION["created_user_id"] = $user->ID;
                $_SESSION["user_verify_phone_time"] = $user_verify_phone_time;
                $_SESSION['dontShowPopup'] = true;


                $coupon_added_to_cart = 0;
                if (WC()->cart->is_empty()) {
                    $_SESSION['couponCode'] = $code;
                } else {
                    WC()->cart->add_discount($code);
                    $coupon_added_to_cart = 1;
                }

                WhatsAppUsers::create_or_update($fullPhoneNumber, [
                    'phone_verified' => 1,
                    'user_verify_phone_time' => $user_verify_phone_time,
                    'coupon_added_to_cart' => $coupon_added_to_cart,
                    'coupon_code' => $code,
                ]);

                $response = [
                    'status' => 'success',
                    'message' => 'ok'
                ];
            } else {
                $response = [
                    'status' => 'error',
                    'message' => 'invalid code'
                ];
            }
        } else {
            $response = [
                'status' => 'error',
                'message' => 'phone number or code is missing'
            ];
        }
    } else if ($action == 'wc_custom_popup_close_popup') {
        $_SESSION["dontShowPopup"] = true;
        $response = [
            'status' => 'success',
            'message' => 'ok'
        ];
    } else if ($action == 'wc_custom_popup_checkpopup') {
        $options = get_option('whatsapp_notification_settings');
        $whatsapp_notification_initial_coupon_visible = $options['whatsapp_notification_initial_coupon_visible'] ?? 'false';  // Using the null coalescing operator to avoid undefined index notice.
        if ($whatsapp_notification_initial_coupon_visible == 'true') {
            if (isset($_SESSION['dontShowPopup']) && $_SESSION['dontShowPopup'] == true) {
                $response = [
                    'status' => 'success',
                    'message' => 'true'
                ];
            } else {
                $response = [
                    'status' => 'success',
                    'message' => 'false'
                ];
            }
        }
    } else if ($action == 'wc_custom_popup_apply_coupon') {
        $coupon = sanitize_input($_POST['coupon']);
        WC()->cart->add_discount($coupon);
        $response = [
            'status' => 'success',
            'message' => 'ok'
        ];
    } else if ($action == 'wc_custom_popup_get_server_ip') {
        $response = [
            'status' => 'success',
            'message' => true
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'invalid action'
        ];
    }

    echo json_encode($response);
}



function sanitize_input($data)
{
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}
